/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.VWUDDIBrowsePanel;
import filenet.vw.toolkit.utils.ws.VWUDDIRegistryManager;
import filenet.vw.toolkit.utils.ws.VWUDDIWorkflowPublishPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class VWUDDIPublishDialog
extends VWModalDialog
implements ActionListener,
Runnable,
ChangeListener {
    private Frame m_parentFrame = null;
    private VWSession m_session = null;
    private JTabbedPane m_tabbedPanel = null;
    private VWUDDIRegistryManager m_uddiRegistryManager = null;
    private VWUDDIBrowsePanel m_browsePanel = null;
    private VWUDDIWorkflowPublishPanel m_workflowPublishPanel = null;
    private JPanel m_buttonPanel = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private Thread m_initThread = null;
    private Object m_syncObject = new Object();

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:56:28  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.8  $";
    }

    public VWUDDIPublishDialog(Frame parent, VWSession session) {
        super(parent);
        this.m_parentFrame = parent;
        this.init(session);
    }

    private void init(VWSession session) {
        this.m_session = session;
        VWUDDIRegistryList vwUDDIRegistryList = new VWUDDIRegistryList(this.m_session);
        this.m_uddiRegistryManager = new VWUDDIRegistryManager(session, vwUDDIRegistryList);
        this.m_workflowPublishPanel = new VWUDDIWorkflowPublishPanel(this.m_parentFrame, session, this.m_uddiRegistryManager);
        this.m_browsePanel = new VWUDDIBrowsePanel(this.m_parentFrame, session, this.m_uddiRegistryManager);
        this.setupLayout();
        this.m_initThread = new Thread(this);
        this.m_initThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object object = this.m_syncObject;
            synchronized (object) {
                this.m_uddiRegistryManager.initData(this);
            }
            object = this.m_syncObject;
            synchronized (object) {
                this.m_workflowPublishPanel.initData(this.m_uddiRegistryManager);
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
        if (this.m_initThread != null && this.m_initThread.isAlive()) {
            try {
                try {
                    this.m_initThread.join();
                }
                catch (InterruptedException interruptedException) {
                    Object var5_7 = null;
                    this.m_initThread = null;
                }
                Object var5_6 = null;
                this.m_initThread = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.m_initThread = null;
                throw throwable;
            }
        }
    }

    private void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension("825, 665");
        if (dim == null) {
            dim = new Dimension(750, 600);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_uddiPublishDialogTitle);
        VWAccessibilityHelper.setAccessibility(this, null, VWResource.s_uddiPublishDialogTitle, VWResource.s_uddiPublishDialogTitle);
        this.m_tabbedPanel = new JTabbedPane();
        this.m_tabbedPanel.addChangeListener(this);
        if (this.m_workflowPublishPanel == null) {
            this.m_workflowPublishPanel = new VWUDDIWorkflowPublishPanel(this.m_parentFrame, this.m_session, this.m_uddiRegistryManager);
        }
        if (this.m_browsePanel == null) {
            this.m_browsePanel = new VWUDDIBrowsePanel(this.m_parentFrame, this.m_session, this.m_uddiRegistryManager);
        }
        this.m_tabbedPanel.add(VWResource.s_publishWorkflow, this.m_workflowPublishPanel);
        this.m_tabbedPanel.add(VWResource.s_browseUDDI, this.m_browsePanel);
        VWAccessibilityHelper.setAccessibility(this.m_workflowPublishPanel, this, VWResource.s_publishWorkflow, VWResource.s_publishWorkflow);
        VWAccessibilityHelper.setAccessibility(this.m_browsePanel, this, VWResource.s_browseUDDI, VWResource.s_browseUDDI);
        this.m_buttonPanel = new JPanel();
        this.m_closeButton = new JButton(VWResource.s_close);
        this.m_helpButton = new JButton(VWResource.s_help);
        this.m_buttonPanel.setLayout(new FlowLayout());
        this.m_buttonPanel.add(this.m_closeButton);
        this.m_buttonPanel.add(this.m_helpButton);
        VWAccessibilityHelper.setAccessibility(this.m_closeButton, this, VWResource.s_close, VWResource.s_close);
        VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this.m_tabbedPanel, "Center");
        panel.add((Component)this.m_buttonPanel, "Last");
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)panel, "Center");
        this.m_closeButton.addActionListener(this);
        this.m_helpButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_closeButton) {
            if (this.m_browsePanel != null && !this.m_browsePanel.onClosePanel()) {
                return;
            }
            if (this.m_uddiRegistryManager != null) {
                this.m_uddiRegistryManager.setAbortInit(true);
            }
            this.setVisible(false);
        } else if (source == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc094.htm");
        }
    }

    public void windowClosing(WindowEvent event) {
        if (this.m_browsePanel != null && this.m_browsePanel.hasUnpublishedData()) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_closePublishDialogWarning2, VWResource.s_uddiPublishDialogTitle, 3);
        }
        super.windowClosing(event);
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabPane;
        Component component;
        Object source = e.getSource();
        if (source instanceof JTabbedPane && (component = (tabPane = (JTabbedPane)source).getSelectedComponent()) instanceof VWUDDIBrowsePanel) {
            VWUDDIBrowsePanel panel = (VWUDDIBrowsePanel)component;
        }
    }
}

